﻿'版权所有 (C) Microsoft Corporation。保留所有权利。

Imports System
Imports System.Collections
Imports System.Collections.Generic
Imports System.Linq
Imports nwind

Namespace Samples
    Public Class Samples

        Public Shared Sub Sample1(ByVal db As Northwind)
            ' 使用 Where() 仅查找匹配的元素
            Dim q As IEnumerable(Of Customer) = db.Customers.Where(Function(c) c.City = "London")
            ObjectDumper.Write(q, 0)
        End Sub

        Public Shared Sub Sample2(ByVal db As Northwind)
            ' 使用 First() 替换 Where()，以查找第一个元素，或仅查找一个元素
            Dim cust As Customer = db.Customers.First(Function(c) c.CustomerID = "ALFKI")
            ObjectDumper.Write(cust, 0)
        End Sub

        Public Shared Sub Sample3(ByVal db As Northwind)
            ' 使用 Select() 映射/投影结果
            Dim q = db.Customers.Select(Function(c) c.ContactName)
            ObjectDumper.Write(q, 0)

        End Sub
        Public Shared Sub Sample4(ByVal db As Northwind)
            ' 使用匿名类构造函数仅检索特定数据
            Dim q = db.Customers.Select(Function(c) New With {c.ContactName, c.Phone})
            ObjectDumper.Write(q, 0)
        End Sub

        Public Shared Sub Sample5(ByVal db As Northwind)
            ' 结合使用 Where() 和 Select() 进行一般查询
            Dim q = db.Customers.Where(Function(c) c.City = "London").Select(Function(c) c.ContactName)
            ObjectDumper.Write(q, 0)

        End Sub
        Public Shared Sub Sample6(ByVal db As Northwind)
            ' 使用 SelectMany() 来扁平化集合
            Dim q As IEnumerable(Of Order) = db.Customers.SelectMany(Function(c) c.Orders)
            ObjectDumper.Write(q, 0)
        End Sub

        Public Shared Sub Sample7(ByVal db As Northwind)
            ' 使用查询表达式简化通用 select/where 模式
            Dim q = From c In db.Customers _
                    From o In c.Orders _
                    Where c.City = "London" _
                    Select New With {c.ContactName, o.OrderDate}
            ObjectDumper.Write(q, 0)
        End Sub

        Public Shared Sub Sample8(ByVal db As Northwind)
            ' 使用 orderby 对结果进行排序
            Dim q = From c In db.Customers Order By c.City, c.ContactName Select c
            ObjectDumper.Write(q, 0)
        End Sub

        Public Shared Sub Sample9(ByVal db As Northwind)
            ' 使用 group x by y 来产生一系列组分区
            Dim q = From p In db.Products Group p By p.CategoryID Into Group Select New With {.CategoryID = Group, Group}
            ObjectDumper.Write(q, 1)
        End Sub

        Public Shared Sub Sample10(ByVal db As Northwind)
            ' 使用 group-by 和 Min()/Max() 之类的聚合函数对组分区计算值
            Dim q = From p In db.Products _
                    Group p By p.CategoryID Into Group _
                    Select New With { _
                        .Category = CategoryID, _
                        .MinPrice = Group.Min(Function(p) p.UnitPrice), _
                        .MaxPrice = Group.Max(Function(p) p.UnitPrice) _
                        }
            ObjectDumper.Write(q, 1)
        End Sub

        Public Shared Sub Sample11(ByVal db As Northwind)
            ' 使用 Any() 确定集合是否至少有一个元素，或至少有一个匹配条件的元素
            Dim q = From c In db.Customers _
                    Where c.Orders.Any() _
                    Select c
            ObjectDumper.Write(q, 0)

        End Sub
        Public Shared Sub Sample12(ByVal db As Northwind)
            ' 使用 All() 确定集合的所有元素是否都匹配某个条件(或者确定集合是否是空的!)
            Dim q = From c In db.Customers _
                    Where c.Orders.All(Function(o) o.ShipCity = c.City) _
                    Select c
            ObjectDumper.Write(q, 0)
        End Sub

        Public Shared Sub Sample13(ByVal db As Northwind)
            ' 使用 Take(n) 将序列限制为仅含有前 n 个元素
            Dim q = db.Customers.OrderBy(Function(c) c.ContactName).Take(5)
            ObjectDumper.Write(q, 0)
        End Sub

        Public Shared Sub Sample14(ByVal db As Northwind)
            ' 使用 SubmitChanges() 将所有更改提交回数据库
            Dim cust = db.Customers.First(Function(c) c.CustomerID = "ALFKI")
            cust.ContactTitle = "Sith Lord"
            ' 其他更改 ...
            db.SubmitChanges()
        End Sub

        Public Shared Sub Sample15(ByVal db As Northwind)

            Using ts As System.Transactions.TransactionScope = New System.Transactions.TransactionScope()
                ' 使用 SubmitChanges() 将所有更改提交回数据库
                Dim cust = db.Customers.First(Function(c) c.CustomerID = "ALFKI")
                cust.ContactTitle = "Sith Lord"
                ' 其他更改 ...
                db.SubmitChanges()
                ts.Complete()
            End Using
        End Sub
    End Class
End Namespace
